local prevhealthP1 = "HealthState_Alive"
local prevhealthP2 = "HealthState_Alive"


return Def.ActorFrame{
	Def.ActorFrame{
		Name="DeadP1";
		Def.ActorFrame{
			BeginCommand=function(self)
				local style = GAMESTATE:GetCurrentStyle()
				local styleType = style:GetStyleType()
				self:visible( styleType ~= "StyleType_OnePlayerTwoSides" and styleType ~= "StyleType_TwoPlayersSharedSides" )
			end;
			HealthStateChangedMessageCommand=function(self, param)
				if param.PlayerNumber == PLAYER_1 then
					if param.HealthState == "HealthState_Dead" then
						self:RunCommandsOnChildren(function(self) self:playcommand("Show") end)
						prevHealthP1 = "HealthState_Dead"
					end
				end
			end;
			-- SFX
			LoadActor("_blazed") .. {
				ShowSunMessageCommand=function(self) self:play() end;
			};
			-- SFX
			LoadActor("woosh") .. {
				ShowMessageCommand=function(self) self:play() end;
			};
			LoadActor("_fire")..{
				Name="DeadP1";
				Condition=Center1Player() == false;
				InitCommand=function(self)
					self:y(SCREEN_BOTTOM+150):x(-1*SCREEN_WIDTH/8):draworder(101):zoom(1.5):y(SCREEN_BOTTOM+230)
					:fadebottom(0.1):faderight(0.1):diffusealpha(0):blend("add"):player(PLAYER_1)
				end;			
				ShowMessageCommand=function(self)
					self:finishtweening():diffusealpha(1):addrotationz(45):linear(0.8):addy(-730):addx(SCREEN_WIDTH*3/2):linear(0.2):diffusealpha(0):queuecommand("Hide") end;
				HideCommand=function(self)
					self:finishtweening():y(SCREEN_BOTTOM+150):x(-1*SCREEN_WIDTH/8):addrotationz(-45) end;
			};
			LoadActor("Fireworks.mp4")..{		
				InitCommand=function(self)
					self:visible(false)
				end,
				FireworksMessageCommand= function(self)
						self:visible(true):loop(true):rate(1.5)
						local src_w = self:GetTexture():GetSourceWidth()
						self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w))
						self:diffusealpha(0):linear(0.5):diffusealpha(0.2):sleep(3.25):linear(0.5):diffusealpha(0)
						--Zoom the background video based on the width of the original mp4
						-- so that it fits perfectly in 16:9 and crop the sides in 4:3 borrowed' from quietly-turning's watermelon
				end,
			},
		};
	};

};